/// annual averages using the full set 
clear 
use "/Users/natashasarin/Dropbox/Z__Natamir/Natasha_Research/Banks/Control Banks/Control_Data/Stack/fullvars_stack.dta"
gen imp_minus_market = impvol - market_imp 
gen vol_minus_market = vol_thirty - market_vol 
gen imp_div_market = impvol/market_imp
gen vol_div_market=vol_thirty/market_vol 
gen crisis = . 
replace crisis = 0 if year >= 2002 & year <= 2007 
replace crisis = 1 if year >= 2010
**replace crisis = 2 if year == 2015  
drop if crisis == . 
gen big6 = 0 
replace big6 = 1 if name == "baml" | name == "ms" | name == "jpm" | name == "gs" | name == "wf" | name == "citi"

by crisis name, sort: egen beta_crisis = mean(beta)
by crisis name, sort: egen cds_crisis = mean(cds)
by crisis name, sort: egen vol_crisis = mean(vol) 
by crisis name, sort: egen impvol_crisis = mean(impvol)
by crisis name, sort: egen ptb_crisis = mean(ptb)
by crisis name, sort: egen imp_minus_market_crisis = mean(imp_minus_market)
by crisis name, sort: egen vol_minus_market_crisis = mean(vol_minus_market)
by crisis name, sort: egen vol_div_market_crisis = mean(vol_div_market)
by crisis name, sort: egen imp_div_market_crisis = mean(imp_div_market)
by crisis name, sort: egen markcap_crisis = mean(markcap)
drop output_indicator
by crisis name, sort: gen output_indicator = _n 
*replace output_indicator = 0 if output_indicator != 1
 
*** for just big6 
*** top 50 need quintiles 


br name crisis markcap_crisis vol_crisis vol_div_market_crisis vol_minus_market_crisis impvol_crisis imp_div_market_crisis imp_minus_market_crisis beta_crisis cds_crisis ptb_crisis if output_indicator == 1 & crisis != . & big6 == 1  

****kill big 6 = 1 in order to compute quntiles. turn this on for bank quintiles 
**drop if big6 == 1 
egen quant_markcap = xtile(markcap_crisis), n(5) by(crisis) 
br name crisis markcap_crisis vol_crisis vol_div_market_crisis vol_minus_market_crisis impvol_crisis imp_div_market_crisis imp_minus_market_crisis beta_crisis cds_crisis ptb_crisis quant_markcap if output_indicator == 1 & crisis != .


*now we want it in quintiles for non big 6 banks. 
drop if quant_markcap == . 
by crisis quant_markcap, sort: egen beta_crisis_quant = mean(beta)
by crisis quant_markcap, sort: egen cds_crisis_quant = mean(cds)
by crisis quant_markcap, sort: egen vol_crisis_quant = mean(vol) 
by crisis quant_markcap, sort: egen impvol_crisis_quant = mean(impvol)
by crisis quant_markcap, sort: egen ptb_crisis_quant = mean(ptb)
by crisis quant_markcap, sort: egen imp_minus_market_crisis_quant = mean(imp_minus_market)
by crisis quant_markcap, sort: egen vol_minus_market_crisis_quant = mean(vol_minus_market)
by crisis quant_markcap, sort: egen vol_div_market_crisis_quant = mean(vol_div_market)
by crisis quant_markcap, sort: egen imp_div_market_crisis_quant = mean(imp_div_market)
by crisis quant_markcap, sort: egen markcap_crisis_quant = mean(markcap)
drop output_indicator
by crisis quant_markcap, sort: gen output_indicator = _n 
br crisis quant_markcap markcap_crisis_quant vol_crisis_quant vol_div_market_crisis_quant vol_minus_market_crisis_quant impvol_crisis_quant imp_div_market_crisis_quant imp_minus_market_crisis_quant beta_crisis_quant cds_crisis_quant ptb_crisis_quant quant_markcap if output_indicator == 1 & crisis != .
 
 *** now we want list of banks in each quintile in each period 
 drop output_indicator 
 by name quant_markcap crisis, sort: gen output_indicator = _n 
 br name crisis markcap_crisis quant_markcap  if output_indicator == 1 & crisis == 0 


